/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.util;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_5285;
import net.minecraft.class_5363;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGDebugBiomeSource;
import potionstudios.byg.common.world.biome.LazyLoadSeed;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.mixin.access.ChunkGeneratorAccess;

public class BiomeSourceRepairUtils {
    public static void repairBiomeSources(class_2378<class_1959> biomeRegistry, class_5285 worldGenSettings) {
        EndBiomesConfig endBiomesConfig;
        NetherBiomesConfig netherBiomesConfig = NetherBiomesConfig.getConfig(true, false, biomeRegistry);
        if (netherBiomesConfig.forceBYGNetherBiomeSource()) {
            Supplier<class_1966> netherBiomeSource = () -> new BYGNetherBiomeSource(biomeRegistry);
            class_5363 levelStem = (class_5363)worldGenSettings.method_28609().method_29107(class_5363.field_25413);
            if (levelStem == null) {
                BYG.logError(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nSkipping biome source repair....", class_5363.field_25413));
            } else {
                BiomeSourceRepairUtils.repair(levelStem, BYGNetherBiomeSource.LOCATION, netherBiomeSource);
            }
        }
        if ((endBiomesConfig = EndBiomesConfig.getConfig(true, false, biomeRegistry)).forceBYGEndBiomeSource()) {
            Supplier<class_1966> endBiomeSource = () -> new BYGEndBiomeSource(biomeRegistry);
            class_5363 levelStem = (class_5363)worldGenSettings.method_28609().method_29107(class_5363.field_25414);
            if (levelStem == null) {
                BYG.logError(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nSkipping biome source repair....", class_5363.field_25414));
            } else {
                BiomeSourceRepairUtils.repair(levelStem, BYGEndBiomeSource.LOCATION, endBiomeSource);
            }
        }
        for (class_5363 dimension : worldGenSettings.method_28609()) {
            class_1966 biomeSource = dimension.method_29571().method_12098();
            if (!(biomeSource instanceof LazyLoadSeed)) continue;
            LazyLoadSeed lazyLoadSeed = (LazyLoadSeed)biomeSource;
            lazyLoadSeed.lazyLoad(worldGenSettings.method_28028());
        }
    }

    private static boolean repair(class_5363 dimension, class_2960 targetBiomeSourceID, Supplier<class_1966> replacement) {
        class_2794 generator = dimension.method_29571();
        Codec<? extends class_1966> codec = ((BiomeSourceAccess)generator.method_12098()).byg_invokeCodec();
        if (!class_2378.field_25096.method_10221(codec).equals((Object)targetBiomeSourceID) && !(generator.method_12098() instanceof BYGDebugBiomeSource)) {
            class_1966 replacementBiomeSource = replacement.get();
            ((ChunkGeneratorAccess)generator).byg_setBiomeSource(replacementBiomeSource);
            return true;
        }
        return false;
    }
}

